Imports Microsoft.VisualBasic
Imports System.Data
Imports System.Data.SqlClient


Public Class OnlineDiary
    Const conString As String = "Data Source=.\SQLEXPRESS;AttachDbFilename=|DataDirectory|\DiaryDB.mdf;Integrated Security=True;User Instance=True"


    Public Shared Function GetDiaryIdFromUserName(ByVal UserName As String) As Integer
        Dim DiaryId As Integer
        Dim diaryDBConn As New SqlConnection(conString)
        Dim sqlString As String = "GetDiaryIdFromUserName"
        Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)

        Try

            sqlCmd.CommandType = CommandType.StoredProcedure
            sqlCmd.Parameters.AddWithValue("@UserName", UserName)

            diaryDBConn.Open()
            Dim diarySQLDR As SqlDataReader = sqlCmd.ExecuteReader(CommandBehavior.CloseConnection)
            sqlCmd = Nothing
            If diarySQLDR.Read() Then
                DiaryId = CInt(diarySQLDR("DiaryId"))
            Else
                DiaryId = -1
            End If

            diarySQLDR.Close()
            diarySQLDR = Nothing


        Catch ex As Exception
            DiaryId = -1
        Finally
            diaryDBConn.Close()
            diaryDBConn = Nothing
        End Try

        Return DiaryId
    End Function

    Public Shared Sub InsertDiary(ByVal UserName As String, ByVal FirstName As String, ByVal LastName As String)
        Dim diaryDBConn As New SqlConnection(conString)
        Dim sqlString As String = "InsertDiary"
        Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
        sqlCmd.CommandType = CommandType.StoredProcedure

        sqlCmd.Parameters.AddWithValue("@UserName", UserName)
        sqlCmd.Parameters.AddWithValue("@FirstName", FirstName)
        sqlCmd.Parameters.AddWithValue("@LastName", LastName)
        diaryDBConn.Open()
        sqlCmd.ExecuteNonQuery()
        diaryDBConn.Close()
        sqlCmd = Nothing
        diaryDBConn = Nothing

    End Sub

End Class


